
<?php
session_start();
// ১. লগইন চেক
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

include '../api/db.php';

// ২. ড্যাশবোর্ড ডাটা লোড করা
// মোট ইউজার
$total_users_res = $conn->query("SELECT COUNT(*) as count FROM users");
$total_users = $total_users_res->fetch_assoc()['count'];

// পেন্ডিং ডিপোজিট
$pending_dep_res = $conn->query("SELECT COUNT(*) as count FROM transactions WHERE type='deposit' AND status='pending'");
$pending_dep = $pending_dep_res->fetch_assoc()['count'];

// পেন্ডিং উইথড্র
$pending_wd_res = $conn->query("SELECT COUNT(*) as count FROM transactions WHERE type='withdraw' AND status='pending'");
$pending_wd = $pending_wd_res->fetch_assoc()['count'];

// ইউজারদের মোট ব্যালেন্স (দায়)
$balance_res = $conn->query("SELECT SUM(balance_deposit + balance_winning) as total FROM users");
$total_liability = $balance_res->fetch_assoc()['total'] ?? 0;

// শেষ ৫টি ট্রানজ্যাকশন
$recent_trx = $conn->query("SELECT * FROM transactions ORDER BY id DESC LIMIT 5");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { font-family: 'Segoe UI', sans-serif; margin: 0; display: flex; background: #f4f6f9; }
        
        /* Sidebar Styles */
        .sidebar { width: 250px; background: #343a40; color: #fff; height: 100vh; position: fixed; padding-top: 20px; }
        .sidebar h2 { text-align: center; margin-bottom: 30px; color: #00ffc8; }
        .sidebar a { display: block; padding: 15px 20px; color: #c2c7d0; text-decoration: none; transition: 0.3s; }
        .sidebar a:hover, .sidebar a.active { background: #495057; color: #fff; }
        .sidebar i { margin-right: 10px; width: 20px; }
        .badge { background: #ff3366; color: white; padding: 2px 6px; border-radius: 4px; font-size: 12px; float: right; }

        /* Main Content */
        .main-content { margin-left: 250px; padding: 20px; width: 100%; }
        .header { background: #fff; padding: 15px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); margin-bottom: 20px; display: flex; justify-content: space-between; align-items: center; }
        
        /* Stats Grid */
        .stats-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 30px; }
        .stat-card { background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); border-left: 5px solid #00ffc8; }
        .stat-card h3 { margin: 0; color: #666; font-size: 14px; }
        .stat-card p { margin: 10px 0 0; font-size: 24px; font-weight: bold; color: #333; }
        .stat-card.alert { border-left-color: #ff3366; }

        /* Recent Table */
        .table-container { background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #eee; }
        th { background: #f8f9fa; color: #333; }
        .status-pending { color: orange; font-weight: bold; }
        .status-approved { color: green; font-weight: bold; }
    </style>
</head>
<body>

    <!-- Sidebar -->
    <div class="sidebar">
        <h2>BOT CLUB</h2>
        <a href="dashboard.php" class="active"><i class="fas fa-home"></i> Dashboard</a>
        <a href="users.php"><i class="fas fa-users"></i> Users</a>
        <a href="deposits.php">
            <i class="fas fa-money-bill-wave"></i> Deposits 
            <?php if($pending_dep > 0) echo "<span class='badge'>$pending_dep</span>"; ?>
        </a>
        <a href="withdraws.php">
            <i class="fas fa-hand-holding-usd"></i> Withdrawals
            <?php if($pending_wd > 0) echo "<span class='badge'>$pending_wd</span>"; ?>
        </a>
        <a href="settings.php"><i class="fas fa-cogs"></i> Settings</a>
        <a href="logout.php" style="color: #ff3366;"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="header">
            <h3>Dashboard Overview</h3>
            <span>Admin</span>
        </div>

        <div class="stats-grid">
            <div class="stat-card">
                <h3>Total Users</h3>
                <p><?php echo $total_users; ?></p>
            </div>
            <div class="stat-card alert">
                <h3>Pending Deposits</h3>
                <p><?php echo $pending_dep; ?></p>
            </div>
            <div class="stat-card alert">
                <h3>Pending Withdrawals</h3>
                <p><?php echo $pending_wd; ?></p>
            </div>
            <div class="stat-card">
                <h3>User Liability (Balance)</h3>
                <p>৳<?php echo number_format($total_liability, 2); ?></p>
            </div>
        </div>

        <div class="table-container">
            <h3>Recent Transactions</h3>
            <table>
                <thead>
                    <tr>
                        <th>UID</th>
                        <th>Type</th>
                        <th>Amount</th>
                        <th>Method</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = $recent_trx->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $row['user_uid']; ?></td>
                        <td><?php echo ucfirst($row['type']); ?></td>
                        <td>৳<?php echo $row['amount']; ?></td>
                        <td><?php echo $row['method']; ?></td>
                        <td class="status-<?php echo $row['status']; ?>"><?php echo ucfirst($row['status']); ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>

</body>
</html>
