
<?php
session_start();
// মেইন ফোল্ডারের db.php ফাইলটি ইনক্লুড করা
include '../api/db.php';

// যদি ইতিমধ্যে লগইন করা থাকে, ড্যাশবোর্ডে পাঠাও
if (isset($_SESSION['admin_logged_in'])) {
    header("Location: dashboard.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // হার্ডকোড করা সিকিউরিটি (যদি ডেটাবেস কাজ না করে)
    // ইউজারনেম: admin, পাসওয়ার্ড: 123456
    if ($username === 'admin' && $password === '123456') {
        $_SESSION['admin_logged_in'] = true;
        header("Location: dashboard.php");
        exit;
    }

    // অথবা ডেটাবেস চেক (যদি আপনি SQL দিয়ে এডমিন সেট করে থাকেন)
    /*
    $stmt = $conn->prepare("SELECT password FROM admins WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        if (password_verify($password, $row['password'])) {
            $_SESSION['admin_logged_in'] = true;
            header("Location: dashboard.php");
            exit;
        }
    }
    */
    
    $error = "ভুল ইউজারনেম বা পাসওয়ার্ড!";
}
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - BOT CLUB</title>
    <style>
        body { background: #0e0e0e; color: #fff; font-family: sans-serif; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
        .login-box { background: #1f1f1f; padding: 30px; border-radius: 10px; width: 300px; text-align: center; border: 1px solid #333; }
        input { width: 90%; padding: 10px; margin: 10px 0; background: #333; border: 1px solid #444; color: #fff; border-radius: 5px; }
        button { width: 100%; padding: 10px; background: #00ffc8; border: none; font-weight: bold; cursor: pointer; border-radius: 5px; margin-top: 10px; }
        .error { color: #ff3366; margin-bottom: 10px; font-size: 14px; }
        h2 { color: #00ffc8; }
    </style>
</head>
<body>
    <div class="login-box">
        <h2>Admin Panel</h2>
        <?php if($error) echo "<p class='error'>$error</p>"; ?>
        <form method="POST">
            <input type="text" name="username" placeholder="Username" required>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>
