
<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

include '../api/db.php';

$message = "";
$edit_user = null;

// ---------------------------------------------------
// ১. ইউজার ব্যালেন্স আপডেট করা (Update Action)
// ---------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_user'])) {
    $id = intval($_POST['user_id']);
    $deposit = floatval($_POST['balance_deposit']);
    $winning = floatval($_POST['balance_winning']);
    $password = $_POST['new_password'];

    $sql = "UPDATE users SET balance_deposit = $deposit, balance_winning = $winning";
    
    // যদি পাসওয়ার্ড ফিল্ড খালি না থাকে, তবে পাসওয়ার্ডও আপডেট হবে
    if (!empty($password)) {
        $hashed = password_hash($password, PASSWORD_DEFAULT);
        $sql .= ", password = '$hashed'";
    }
    
    $sql .= " WHERE id = $id";

    if ($conn->query($sql)) {
        $message = "<div class='alert success'>User updated successfully!</div>";
    } else {
        $message = "<div class='alert error'>Error updating user!</div>";
    }
}

// ---------------------------------------------------
// ২. এডিট করার জন্য ইউজার ডাটা আনা
// ---------------------------------------------------
if (isset($_GET['edit_id'])) {
    $id = intval($_GET['edit_id']);
    $edit_res = $conn->query("SELECT * FROM users WHERE id = $id");
    $edit_user = $edit_res->fetch_assoc();
}

// ---------------------------------------------------
// ৩. ইউজার সার্চ এবং লিস্ট লোড করা
// ---------------------------------------------------
$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';
$sql = "SELECT * FROM users";

if (!empty($search)) {
    $sql .= " WHERE uid LIKE '%$search%' OR phone LIKE '%$search%'";
}

$sql .= " ORDER BY id DESC LIMIT 50"; // লেটেস্ট ৫০ জন দেখাবে (সার্চ করলে সব আসবে)
$users = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Users</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { font-family: 'Segoe UI', sans-serif; margin: 0; display: flex; background: #f4f6f9; }
        .sidebar { width: 250px; background: #343a40; color: #fff; height: 100vh; position: fixed; padding-top: 20px; }
        .sidebar a { display: block; padding: 15px 20px; color: #c2c7d0; text-decoration: none; }
        .sidebar a:hover { background: #495057; color: #fff; }
        .sidebar i { margin-right: 10px; width: 20px; }
        
        .main-content { margin-left: 250px; padding: 20px; width: 100%; }
        .card { background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); margin-bottom: 20px; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #eee; }
        th { background: #f1f1f1; color: #333; }
        
        .btn { padding: 5px 10px; border: none; border-radius: 4px; cursor: pointer; color: white; text-decoration: none; font-size: 14px; }
        .btn-edit { background: #007bff; }
        .btn-save { background: #28a745; width: 100%; padding: 10px; font-size: 16px; margin-top: 10px; }
        
        .search-box { display: flex; gap: 10px; margin-bottom: 20px; }
        .search-box input { padding: 10px; width: 300px; border: 1px solid #ddd; border-radius: 4px; }
        .search-box button { padding: 10px 20px; background: #333; color: white; border: none; border-radius: 4px; cursor: pointer; }
        
        .form-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: bold; color: #555; }
        .form-group input { width: 95%; padding: 10px; border: 1px solid #ccc; border-radius: 4px; }
        
        .alert { padding: 10px; margin-bottom: 20px; border-radius: 5px; }
        .alert.success { background: #d4edda; color: #155724; }
        .alert.error { background: #f8d7da; color: #721c24; }
    </style>
</head>
<body>

    <!-- Sidebar -->
    <div class="sidebar">
        <h2 style="text-align:center; color:#00ffc8; border:none;">BOT CLUB</h2>
        <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
        <a href="users.php" style="background: #495057; color: #fff;"><i class="fas fa-users"></i> Users</a>
        <a href="deposits.php"><i class="fas fa-money-bill-wave"></i> Deposits</a>
        <a href="withdraws.php"><i class="fas fa-hand-holding-usd"></i> Withdrawals</a>
        <a href="settings.php"><i class="fas fa-cogs"></i> Settings</a>
        <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>

    <div class="main-content">
        <?php echo $message; ?>

        <!-- Edit User Form (Only shows when Edit button is clicked) -->
        <?php if($edit_user): ?>
        <div class="card" style="border-top: 3px solid #007bff;">
            <h3>Edit User: <?php echo $edit_user['name']; ?> (UID: <?php echo $edit_user['uid']; ?>)</h3>
            <form method="POST" action="users.php">
                <input type="hidden" name="user_id" value="<?php echo $edit_user['id']; ?>">
                <input type="hidden" name="update_user" value="1">
                
                <div class="form-grid">
                    <div class="form-group">
                        <label>Deposit Balance</label>
                        <input type="number" step="0.01" name="balance_deposit" value="<?php echo $edit_user['balance_deposit']; ?>">
                    </div>
                    <div class="form-group">
                        <label>Winning Balance</label>
                        <input type="number" step="0.01" name="balance_winning" value="<?php echo $edit_user['balance_winning']; ?>">
                    </div>
                    <div class="form-group">
                        <label>New Password (Leave empty to keep current)</label>
                        <input type="text" name="new_password" placeholder="Enter new password">
                    </div>
                </div>
                <button type="submit" class="btn btn-save">Update User Info</button>
                <a href="users.php" style="display:block; text-align:center; margin-top:10px; color:#666;">Cancel</a>
            </form>
        </div>
        <?php endif; ?>

        <!-- Search & List -->
        <div class="card">
            <div style="display:flex; justify-content:space-between; align-items:center;">
                <h2>User List</h2>
                <form class="search-box" method="GET">
                    <input type="text" name="search" placeholder="Search by UID or Phone..." value="<?php echo htmlspecialchars($search); ?>">
                    <button type="submit">Search</button>
                </form>
            </div>
            
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>UID</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Deposit Bal</th>
                        <th>Winning Bal</th>
                        <th>Referrer</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($users->num_rows > 0): ?>
                        <?php while($row = $users->fetch_assoc()): ?>
                        <tr>
                            <td>#<?php echo $row['id']; ?></td>
                            <td style="font-weight:bold; color:#007bff;"><?php echo $row['uid']; ?></td>
                            <td><?php echo $row['name']; ?></td>
                            <td><?php echo $row['phone']; ?></td>
                            <td>৳<?php echo $row['balance_deposit']; ?></td>
                            <td>৳<?php echo $row['balance_winning']; ?></td>
                            <td><?php echo $row['referred_by'] ? $row['referred_by'] : '-'; ?></td>
                            <td>
                                <a href="users.php?edit_id=<?php echo $row['id']; ?>" class="btn btn-edit">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="8" style="text-align:center;">No users found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</body>
</html>