
<?php
// ডাটাবেস কানেকশন যুক্ত করা
include 'db.php';

// ১. শুধুমাত্র POST রিকোয়েস্ট এক্সেপ্ট করা
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid Request Method"]);
    exit;
}

// ২. ইনপুট নেওয়া এবং স্যানিটাইজ করা
$phone = isset($_POST['phone']) ? $conn->real_escape_string($_POST['phone']) : '';
$password = isset($_POST['password']) ? $_POST['password'] : '';

// ৩. খালি ঘর চেক করা
if (empty($phone) || empty($password)) {
    echo json_encode(["status" => "error", "message" => "Phone and Password are required!"]);
    exit;
}

// ৪. ইউজার খোঁজা (ফোন নাম্বার দিয়ে)
$sql = "SELECT * FROM users WHERE phone = '$phone'";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // ইউজার পাওয়া গেছে, এখন ডাটা বের করি
    $user = $result->fetch_assoc();

    // ৫. পাসওয়ার্ড যাচাই করা (Hash চেক)
    if (password_verify($password, $user['password'])) {
        
        // সিকিউরিটির জন্য রেসপন্স থেকে পাসওয়ার্ড ফিল্ডটি সরিয়ে ফেলা
        unset($user['password']); 

        // ৬. সফল রেসপন্স পাঠানো
        echo json_encode([
            "status" => "success",
            "message" => "Login Successful!",
            "user" => $user // ইউজারের সব তথ্য (UID, Balance ইত্যাদি) ফ্রন্টেন্ডে যাবে
        ]);

    } else {
        // পাসওয়ার্ড ভুল হলে
        echo json_encode(["status" => "error", "message" => "Incorrect Password!"]);
    }

} else {
    // ইউজার না পাওয়া গেলে
    echo json_encode(["status" => "error", "message" => "User not found with this phone number!"]);
}

$conn->close();
?>
