
<?php
// আগের তৈরি করা db.php ফাইলটি যুক্ত করা হলো
include 'db.php';

// ১. চেক করা রিকোয়েস্টটি POST কিনা
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid Request Method"]);
    exit;
}

// ২. ফ্রন্টেন্ড থেকে ডাটা রিসিভ করা এবং সিকিউর করা (SQL Injection রোধে)
$name = isset($_POST['name']) ? $conn->real_escape_string($_POST['name']) : '';
$phone = isset($_POST['phone']) ? $conn->real_escape_string($_POST['phone']) : '';
$password = isset($_POST['password']) ? $_POST['password'] : '';
$ref_code = isset($_POST['ref_code']) ? $conn->real_escape_string($_POST['ref_code']) : '';

// ৩. খালি ঘর চেক করা
if (empty($name) || empty($phone) || empty($password)) {
    echo json_encode(["status" => "error", "message" => "All fields (Name, Phone, Password) are required!"]);
    exit;
}

// ৪. ফোন নাম্বার আগে থেকেই আছে কিনা চেক করা
$check_phone = $conn->query("SELECT id FROM users WHERE phone = '$phone'");
if ($check_phone->num_rows > 0) {
    echo json_encode(["status" => "error", "message" => "This phone number is already registered!"]);
    exit;
}

// ৫. রেফারেল কোড ভ্যালিডেশন (যদি ইউজার রেফার কোড দেয়)
$valid_referrer = "NULL"; // ডিফল্ট হিসেবে নাল (যদি রেফার না থাকে)

if (!empty($ref_code)) {
    // চেক করি এই কোড (UID) ওয়ালা কোনো ইউজার আছে কিনা
    $check_ref = $conn->query("SELECT uid FROM users WHERE uid = '$ref_code'");
    if ($check_ref->num_rows > 0) {
        $valid_referrer = "'$ref_code'"; // ভ্যালিড হলে কোডটি সেট হবে
    } else {
        // যদি ভুল রেফার কোড দেয়, তাহলে এরর দেখাবো
        echo json_encode(["status" => "error", "message" => "Invalid Referral Code!"]);
        exit;
    }
}

// ৬. ইউনিক ৬ সংখ্যার UID জেনারেট করা
$uid = 0;
$is_unique = false;

while (!$is_unique) {
    $uid = rand(100000, 999999); // ৬ সংখ্যার র‍্যান্ডম নাম্বার
    // চেক করি এই UID অন্য কারো আছে কিনা
    $check_uid = $conn->query("SELECT id FROM users WHERE uid = '$uid'");
    if ($check_uid->num_rows == 0) {
        $is_unique = true; // ইউনিক পাওয়া গেছে, লুপ ব্রেক হবে
    }
}

// ৭. পাসওয়ার্ড এনক্রিপশন (সিকিউরিটির জন্য)
$hashed_password = password_hash($password, PASSWORD_DEFAULT);

// ৮. ফাইনাল ডাটাবেসে সেভ করা
$sql = "INSERT INTO users (uid, name, phone, password, referred_by) 
        VALUES ('$uid', '$name', '$phone', '$hashed_password', $valid_referrer)";

if ($conn->query($sql) === TRUE) {
    // সফল হলে রেসপন্স
    echo json_encode([
        "status" => "success", 
        "message" => "Registration Successful!",
        "uid" => $uid
    ]);
} else {
    // কোনো টেকনিক্যাল সমস্যা হলে
    echo json_encode(["status" => "error", "message" => "Database Error: " . $conn->error]);
}

$conn->close();
?>