
<?php
// ডাটাবেস কানেকশন
include 'db.php';

// ১. UID রিসিভ করা (GET অথবা POST মেথড দিয়ে)
$uid = '';
if (isset($_GET['uid'])) {
    $uid = $conn->real_escape_string($_GET['uid']);
} elseif (isset($_POST['uid'])) {
    $uid = $conn->real_escape_string($_POST['uid']);
} else {
    echo json_encode(["status" => "error", "message" => "UID is required"]);
    exit;
}

// ২. মেইন ইউজার টেবিল থেকে ডাটা আনা
$sql = "SELECT * FROM users WHERE uid = '$uid'";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();

    // ৩. আজকের তারিখ বের করা (Bangladesh Timezone, db.php তে সেট করা আছে)
    $today = date('Y-m-d');

    // --- অতিরিক্ত স্ট্যাটাস ক্যালকুলেশন (Dynamic Query) ---

    // A. মোট রেফারেল সংখ্যা বের করা (আপনার ডাউনলাইন কতজন)
    $ref_count_sql = "SELECT COUNT(*) as total FROM users WHERE referred_by = '$uid'";
    $ref_count_res = $conn->query($ref_count_sql);
    $total_referrals = $ref_count_res->fetch_assoc()['total'];

    // B. আজ কতজন জয়েন করেছে (Today's Joined)
    $today_join_sql = "SELECT COUNT(*) as total FROM users WHERE referred_by = '$uid' AND DATE(created_at) = '$today'";
    $today_join_res = $conn->query($today_join_sql);
    $today_joined = $today_join_res->fetch_assoc()['total'];

    // C. আজকের রেফারেল বোনাস ইনকাম বের করা
    // আমরা transactions টেবিল থেকে যোগফল বের করবো যেখানে type='bonus' এবং তারিখ আজকের
    $today_bonus_sql = "SELECT SUM(amount) as total FROM transactions 
                        WHERE user_uid = '$uid' AND type = 'bonus' AND DATE(created_at) = '$today'";
    $today_bonus_res = $conn->query($today_bonus_sql);
    $today_bonus_row = $today_bonus_res->fetch_assoc();
    $today_bonus = $today_bonus_row['total'] ? $today_bonus_row['total'] : "0.00";

    // ৪. সব ডাটা একসাথে JSON আকারে পাঠানো
    echo json_encode([
        "status" => "success",
        "data" => [
            "uid" => $user['uid'],
            "name" => $user['name'],
            "phone" => $user['phone'],
            // ব্যালেন্স ডাটা
            "balance_deposit" => $user['balance_deposit'],
            "balance_winning" => $user['balance_winning'],
            "total_balance" => number_format($user['balance_deposit'] + $user['balance_winning'], 2, '.', ''),
            // রেফারেল ডাটা
            "total_referrals" => $total_referrals,
            "today_joined" => $today_joined,
            "total_bonus" => $user['total_bonus'],
            "today_bonus" => number_format($today_bonus, 2, '.', ''),
            // স্ট্যাটাস
            "has_deposited" => ($user['balance_deposit'] > 0 || $user['balance_winning'] > 0) ? true : false 
            // নোট: has_deposited লজিক সিম্পল রাখা হয়েছে, আপনি চাইলে transactions টেবিল চেক করতে পারেন
        ]
    ]);

} else {
    echo json_encode(["status" => "error", "message" => "User not found"]);
}

$conn->close();
?>
