
<?php
include 'db.php';

// কোন অ্যাকশনটি করতে হবে তা দেখা (get_numbers, deposit, withdraw, history)
$action = isset($_GET['action']) ? $_GET['action'] : '';

// ---------------------------------------------------
// ১. পেমেন্ট নাম্বার পাওয়ার জন্য (Deposit Page)
// ---------------------------------------------------
if ($action == 'get_numbers') {
    $method = isset($_GET['method']) ? $conn->real_escape_string($_GET['method']) : 'bKash';
    
    $sql = "SELECT number, label FROM payment_numbers WHERE method = '$method'";
    $result = $conn->query($sql);
    
    $numbers = [];
    while ($row = $result->fetch_assoc()) {
        $numbers[] = $row;
    }
    
    echo json_encode(["status" => "success", "data" => $numbers]);
    exit;
}

// ---------------------------------------------------
// ২. ডিপোজিট রিকোয়েস্ট জমা দেওয়া (Submit Deposit)
// ---------------------------------------------------
if ($action == 'deposit') {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') exit;

    $uid = $conn->real_escape_string($_POST['uid']);
    $amount = floatval($_POST['amount']);
    $method = $conn->real_escape_string($_POST['method']);
    $trx_id = $conn->real_escape_string($_POST['trx_id']);

    if ($amount < 50) { // মিনিমাম ডিপোজিট চেক
        echo json_encode(["status" => "error", "message" => "Minimum deposit is 50 BDT"]);
        exit;
    }

    // ডুপ্লিকেট TrxID চেক
    $check = $conn->query("SELECT id FROM transactions WHERE trx_id = '$trx_id'");
    if ($check->num_rows > 0) {
        echo json_encode(["status" => "error", "message" => "Transaction ID already used!"]);
        exit;
    }

    $sql = "INSERT INTO transactions (user_uid, type, amount, method, trx_id, status) 
            VALUES ('$uid', 'deposit', $amount, '$method', '$trx_id', 'pending')";

    if ($conn->query($sql)) {
        echo json_encode(["status" => "success", "message" => "Deposit request submitted! Wait for approval."]);
    } else {
        echo json_encode(["status" => "error", "message" => "Database Error"]);
    }
    exit;
}

// ---------------------------------------------------
// ৩. উইথড্র রিকোয়েস্ট (Submit Withdraw)
// ---------------------------------------------------
if ($action == 'withdraw') {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') exit;

    $uid = $conn->real_escape_string($_POST['uid']);
    $amount = floatval($_POST['amount']);
    $method = $conn->real_escape_string($_POST['method']);
    $account = $conn->real_escape_string($_POST['account']); // যে নাম্বারে টাকা নিবে

    if ($amount < 200) { // মিনিমাম উইথড্র
        echo json_encode(["status" => "error", "message" => "Minimum withdrawal is 200 BDT"]);
        exit;
    }

    $conn->begin_transaction();
    try {
        // ব্যালেন্স চেক (Winning Balance থেকেই শুধু উইথড্র হবে)
        $user_q = $conn->query("SELECT balance_winning FROM users WHERE uid = '$uid' FOR UPDATE");
        $user = $user_q->fetch_assoc();

        if ($user['balance_winning'] < $amount) {
            throw new Exception("Insufficient Winning Balance!");
        }

        // ১. ব্যালেন্স কেটে নেওয়া
        $new_bal = $user['balance_winning'] - $amount;
        $conn->query("UPDATE users SET balance_winning = $new_bal WHERE uid = '$uid'");

        // ২. রিকোয়েস্ট জমা দেওয়া
        $sql = "INSERT INTO transactions (user_uid, type, amount, method, trx_id, status) 
                VALUES ('$uid', 'withdraw', $amount, '$method', '$account', 'pending')";
        $conn->query($sql);

        $conn->commit();
        echo json_encode(["status" => "success", "message" => "Withdrawal request submitted!"]);

    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode(["status" => "error", "message" => $e->getMessage()]);
    }
    exit;
}

// ---------------------------------------------------
// ৪. ট্রানজ্যাকশন হিস্টোরি (Wallet Page History)
// ---------------------------------------------------
if ($action == 'history') {
    $uid = $conn->real_escape_string($_GET['uid']);
    
    // শেষ ১০টি ট্রানজ্যাকশন দেখানো
    $sql = "SELECT * FROM transactions WHERE user_uid = '$uid' ORDER BY id DESC LIMIT 10";
    $result = $conn->query($sql);
    
    $history = [];
    while ($row = $result->fetch_assoc()) {
        $history[] = $row;
    }
    
    echo json_encode(["status" => "success", "data" => $history]);
    exit;
}

// কোনো অ্যাকশন না মিললে
echo json_encode(["status" => "error", "message" => "Invalid Action"]);
?>
